* Graphs in section 4.1
* Date last edited 02 October 2018
* File author: Mary-Alice Doyle


clear
set more off
*cd [specify filepath for working directory]
do ".\Stata files\Variables - 2016"
drop if ccown==0


*------------------------------


********
* FIGURE 1
********
* single most important consideration in choosing to have a credit card
tablecol q8d idtag if idtag==1 [pw=w1], colpct nofreq
quietly: tabout q8d if idtag==1 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) replace

* all considerations
forvalues i=1/13 {
	tablecol q8d`i' idtag if idtag==1 [pw=w1], colpct nofreq
	quietly: tabout q8d`i' if idtag==1 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append
	}
* I combined some related responses together for the the graph
* Easy way to borrow and smooth spending between pay periods
gen borrow = 0
replace borrow = 1 if q8d2 == 1 | q8d9 == 1
quietly: tabout borrow if idtag==1 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append clab(borrow)

* Widespread acceptance in Australia and acceptance overseas
gen acceptance = 0
replace acceptance = 1 if q8d7 == 1 | q8d8 == 1
quietly: tabout acceptance if idtag==1 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append clab(acceptance)

* Travel insurance/warranty and other benefits (concierge etc)
gen benefits = 0 
replace benefits = 1 if q8d4 == 1 | q8d5 == 1
quietly: tabout benefits if idtag==1 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append clab(benefits)

* Fraud protection and 'other, please specify' since only 17 people selected fraud protection
gen other = 0
replace other = 1 if q8d11 == 1 | q8d13 == 1
quietly: tabout other if idtag==1 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append clab(other)
*---------------------------------------


********
* FIGURE 2
********
* including respondents who said 'don't know/can't remember' in q8e0, who ended up in 'NA (-1)'

* single most imiportant consideration in choosing which credit card to hold
tablecol q8e idtag if idtag==1 & q8e>-5 [pw=w1], colpct nofreq
quietly: tabout q8e if idtag==1 & q8e>-5 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append

* all considerations
forvalues i=0/13 {
	tablecol q8e`i' idtag if idtag==1 & q8e`i'>=0 [pw=w1], colpct nofreq
	quietly: tabout q8e`i' if idtag==1 & q8e`i'>=0 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append
	}

* I combind some related responses together for the graph
* Card offered by main/preferred bank, linked to mortgage/other account 
//and 'customer service or quality of issuer's website/app'
gen bank = 0
replace bank = 1 if q8e9==1 | q8e11 == 1 | q8e10==1
quietly: tabout bank if idtag==1 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append clab(bank)

* Travel insurance or extended warranty, other benefits (concierge etc) and less costly to use overseas
gen otherbenefits = 0 
replace otherbenefits = 1 if q8e7 == 1 | q8e8 == 1 | q8e12 == 1 
quietly: tabout otherbenefits if idtag==1 [iw=w1] using ".\Excel output\4.1 descriptives.xls", c(col) f(4) append clab(otherbenefits)


